@extends('admin_dashboard')
@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

 <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">Edit Unit </a></li>

                                        </ol>
                                    </div>
                                    <h4 class="page-title">Edit Unit</h4>
                                </div>
                            </div>
                        </div>
                        <!-- end page title -->

<div class="row">


  <div class="col-lg-8 col-xl-12">
<div class="card">
    <div class="card-body">





    <!-- end timeline content-->

    <div class="tab-pane" id="settings">
        <form method="POST" action="{{ route('units.update', $unit->id) }}">
            @csrf

            <div class="mb-3">
                <label class="form-label">Unit Name</label>
                <input type="text" name="unit_name" class="form-control" value="{{ $unit->unit_name }}" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Unit Symbol</label>
                <input type="text" name="unit_symbol" class="form-control" value="{{ $unit->unit_symbol }}" required>
            </div>

            <div class="mb-3 form-check">
                <input type="checkbox" class="form-check-input" id="is_multiple" name="is_multiple"
                    {{ $unit->parentConversion ? 'checked' : '' }}>
                <label class="form-check-label" for="is_multiple">This unit is a multiple of another unit</label>
            </div>

            <div id="multiple-fields" style="display: {{ $unit->parentConversion ? 'block' : 'none' }}">
                <div class="mb-3">
                    <label class="form-label">Multiplier</label>
                    <input type="number" step="0.0001" min="0.0001" name="multiplier" class="form-control"
                           value="{{ $unit->parentConversion->multiplier ?? '' }}">
                </div>

                <div class="mb-3">
                    <label class="form-label">Base Unit</label>
                    <select name="base_unit_id" class="form-control">
                        <option value="">-- Select Base Unit --</option>
                        @foreach($units as $u)
                            <option value="{{ $u->id }}"
                                {{ ($unit->parentConversion && $unit->parentConversion->child_unit_id == $u->id) ? 'selected' : '' }}>
                                {{ $u->unit_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <button class="btn btn-primary w-100">Update Unit</button>
        </form>
    </div>
    <!-- end settings content-->
        <script>
            document.getElementById('is_multiple').addEventListener('change', function () {
                document.getElementById('multiple-fields').style.display =
                    this.checked ? 'block' : 'none';
            });
        </script>


                                    </div>
                                </div> <!-- end card-->

                            </div> <!-- end col -->
                        </div>
                        <!-- end row-->

                    </div> <!-- container -->

                </div> <!-- content -->







@endsection
