<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Recipes Report - {{ $date }}</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 20px;
        }

        h2 {
            text-align: center;
            color: #222;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table, th, td {
            border: 1px solid #444;
        }

        th {
            background-color: #f2f2f2;
            padding: 8px;
            text-align: left;
        }

        td {
            padding: 8px;
            text-align: left;
        }

        tfoot td {
            font-weight: bold;
        }

        .text-center {
            text-align: center;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 10px;
            color: #888;
        }
    </style>
</head>
<body>
<h2>Recipes Report</h2>
<p><strong>Date:</strong> {{ $date }}</p>

<table>
    <thead>
    <tr>
        <th>Recipe</th>
        <th class="text-center">Approved Qty</th>
        <th class="text-center">Sold Qty</th>
        <th class="text-center">Remaining Qty</th>
    </tr>
    </thead>
    <tbody>
    @forelse($report as $row)
        <tr>
            <td>{{ $row->recipe_name }}</td>
            <td class="text-center">{{ $row->approved_qty }}</td>
            <td class="text-center">{{ $row->sold_qty }}</td>
            <td class="text-center">{{ $row->remaining_qty }}</td>
        </tr>
    @empty
        <tr>
            <td colspan="4" class="text-center">No recipes found for this date.</td>
        </tr>
    @endforelse
    </tbody>
    <tfoot>
    @if(count($report) > 0)
        <tr>
            <td>Total</td>
            <td class="text-center">{{ $report->sum('approved_qty') }}</td>
            <td class="text-center">{{ $report->sum('sold_qty') }}</td>
            <td class="text-center">{{ $report->sum('remaining_qty') }}</td>
        </tr>
    @endif
    </tfoot>
</table>

<div class="footer">
    Generated on {{ now()->format('Y-m-d H:i') }}
</div>
</body>
</html>
