@extends('admin_dashboard')

@section('admin')
    <div class="content">
        <h5>Recipes Report</h5>

        <form action="{{ route('reports.recipes.generate') }}" method="GET" class="mb-3">
            <label for="date">Select Date:</label>
            <input type="date" name="date" id="date" value="{{ $date ?? date('Y-m-d') }}" class="form-control w-auto d-inline">
            <button type="submit" class="btn btn-primary">Generate Report</button>
        </form>

        @if(isset($report))
            <h6>Report for: {{ $date }}</h6>
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>Recipe</th>
                    <th>Approved Qty</th>
                    <th>Sold Qty</th>
                    <th>Remaining Qty</th>
                </tr>
                </thead>
                <tbody>
                @forelse($report as $row)
                    <tr>
                        <td>{{ $row->recipe_name }}</td>
                        <td>{{ $row->approved_qty }}</td>
                        <td>{{ $row->sold_qty }}</td>
                        <td>{{ $row->remaining_qty }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center">No recipes found for this date.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>

            <a href="{{ route('reports.recipes.pdf', ['date' => $date]) }}" class="btn btn-danger">
                Download PDF
            </a>
        @endif
    </div>
@endsection
