<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Ingredients Report - {{ $date }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #333;
        }
        h2, h3 {
            text-align: center;
            margin-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #333;
            padding: 6px;
            text-align: center;
        }
        th {
            background-color: #f4f4f4;
        }
        .text-left {
            text-align: left;
        }
    </style>
</head>
<body>
<h2>Ingredients Daily Report</h2>
<h3>Date: {{ \Carbon\Carbon::parse($date)->format('d M, Y') }}</h3>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th class="text-left">Ingredient / Product</th>
        <th>Current Stock</th>
        <th>Purchased Qty</th>
        <th>Used Qty</th>
        <th>Remaining Stock</th>
    </tr>
    </thead>
    <tbody>
    @foreach($report as $index => $item)
        <tr>
            <td>{{ $index + 1 }}</td>
            <td class="text-left">{{ $item->product_name }}</td>
            <td>{{ number_format($item->current_stock, 2) }}</td>
            <td>{{ number_format($item->purchased_qty, 2) }}</td>
            <td>{{ number_format($item->used_qty, 2) }}</td>
            <td>{{ number_format($item->remaining, 2) }}</td>
        </tr>
    @endforeach
    @if(count($report) === 0)
        <tr>
            <td colspan="6">No data available for this date.</td>
        </tr>
    @endif
    </tbody>
</table>

<p style="text-align:center; margin-top: 20px;">
    Generated by POS System
</p>
</body>
</html>
