@extends('admin_dashboard')

@section('admin')
    <div class="content">
        <h5>Ingredients Report</h5>

        <form action="{{ route('reports.ingredients.generate') }}" method="GET" class="mb-3">
            <label for="date">Select Date:</label>
            <input type="date" name="date" id="date" value="{{ date('Y-m-d') }}" class="form-control w-auto d-inline">
            <button type="submit" class="btn btn-primary">Generate Report</button>
        </form>

        @if(isset($report))
            <h6>Report for: {{ $date }}</h6>
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>Product</th>
                    <th>Current Stock</th>
                    <th>Purchased</th>
                    <th>Used</th>
                    <th>Remaining</th>
                </tr>
                </thead>
                <tbody>
                @foreach($report as $row)
                    <tr>
                        <td>{{ $row->product_name }}</td>
                        <td>{{ $row->current_stock }}</td>
                        <td>{{ $row->purchased_qty }}</td>
                        <td>{{ $row->used_qty }}</td>
                        <td>{{ $row->remaining }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <a href="{{ route('reports.ingredients.pdf', ['date' => $date]) }}" class="btn btn-danger">
                Download PDF
            </a>
        @endif
    </div>
@endsection
