@extends('admin_dashboard')
@section('admin')

    <div class="content">
        <div class="container-fluid">

            {{-- PAGE TITLE --}}
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item">Add Recipe</li>
                            </ol>
                        </div>
                        <h4 class="page-title">Add Recipe</h4>
                    </div>
                </div>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            {{-- FORM --}}
            <form method="POST" action="{{ route('recipe.store') }}">
                @csrf

                {{-- FOOD DETAILS --}}
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Recipe Details</h5>

                        <div class="row">
                            <div class="col-md-4 mb-2">
                                <label>Recipe Name</label>
                                <input type="text" name="recipe_name" class="form-control" required>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label>Yield Quantity</label>
                                <input type="number" step="0.01" id="yield_qty" name="yield_qty" class="form-control" required>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label>Yield Unit</label>
                                <select name="yield_unit_id" class="form-select" required>
                                    @foreach($units as $unit)
                                        <option value="{{ $unit->id }}">{{ $unit->unit_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                </div>

                {{-- INGREDIENTS --}}
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Ingredients (Bill of Materials)</h5>

                        <div id="ingredients-wrapper"></div>

                        <button type="button" id="add-ingredient" class="btn btn-secondary mt-2">
                            Add Ingredient
                        </button>
                    </div>
                </div>

{{--                --}}{{-- COST OF PRODUCTION --}}
{{--                <div class="card mb-3">--}}
{{--                    <div class="card-body">--}}
{{--                        <h5 class="card-title text-danger">Cost of Production</h5>--}}

{{--                        <table class="table table-sm">--}}
{{--                            <thead>--}}
{{--                            <tr>--}}
{{--                                <th>Ingredient</th>--}}
{{--                                <th>Qty Used</th>--}}
{{--                                <th>Unit Cost</th>--}}
{{--                                <th>Cost</th>--}}
{{--                            </tr>--}}
{{--                            </thead>--}}
{{--                            <tbody id="cost-breakdown"></tbody>--}}
{{--                        </table>--}}

{{--                        <div class="fw-bold">--}}
{{--                            Total Cost: <span id="total_cost">0.00</span>--}}
{{--                        </div>--}}

{{--                        <div class="fw-bold text-success">--}}
{{--                            Cost Per Unit: <span id="unit_cost">0.00</span>--}}
{{--                        </div>--}}
{{--                        <div class="mt-2">--}}
{{--                            <label>Selling Price (per unit)</label>--}}
{{--                            <input type="number" step="0.01" name="selling_price" class="form-control" required>--}}
{{--                        </div>--}}
{{--                    </div>--}}

{{--                </div>--}}



                {{-- ACTION --}}
                <button type="submit" class="btn btn-primary">
                    Save Food
                </button>
            </form>

            {{-- INGREDIENT TEMPLATE --}}
            <template id="ingredient-template">
                <div class="ingredient-row d-flex gap-2 mb-2">

                    <select name="product_id[]" class="form-select product-select w-50" required>
                        <option value="">Select Ingredient</option>
                        @foreach($products as $product)
                            <option
                                value="{{ $product->id }}"
                                data-unit-cost="{{ $product->unit_cost }}"
                            >
                                {{ $product->product_name }}
                            </option>
                        @endforeach
                    </select>

                    <input type="number"
                           name="quantity[]"
                           step="0.0001"
                           class="form-control qty-input w-25"
                           placeholder="Qty used"
                           required>

                    <button type="button" class="btn btn-danger remove-row">✕</button>
                </div>
            </template>


        </div>
    </div>

    {{-- SCRIPT --}}
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const wrapper = document.getElementById('ingredients-wrapper');
            const template = document.getElementById('ingredient-template');
            const breakdown = document.getElementById('cost-breakdown');
            const totalCostEl = document.getElementById('total_cost');
            const unitCostEl = document.getElementById('unit_cost');
            const yieldInput = document.getElementById('yield_qty');

            function calculate() {
                let total = 0;
                breakdown.innerHTML = '';

                wrapper.querySelectorAll('.ingredient-row').forEach(row => {
                    const select = row.querySelector('.product-select');
                    const qtyInput = row.querySelector('.qty-input');

                    if (!select.value || !qtyInput.value) return;

                    const name = select.selectedOptions[0].text;
                    const unitCost = parseFloat(select.selectedOptions[0].dataset.unitCost) || 0;
                    const qty = parseFloat(qtyInput.value) || 0;

                    const cost = unitCost * qty;
                    total += cost;

                    breakdown.innerHTML += `
                <tr>
                    <td>${name}</td>
                    <td>${qty}</td>
                    <td>${unitCost.toFixed(2)}</td>
                    <td>${cost.toFixed(2)}</td>
                </tr>
            `;
                });

                totalCostEl.textContent = total.toFixed(2);

                const yieldQty = parseFloat(yieldInput.value) || 0;
                unitCostEl.textContent = yieldQty > 0
                    ? (total / yieldQty).toFixed(2)
                    : '0.00';
            }

            function addRow() {
                const clone = template.content.cloneNode(true);
                wrapper.appendChild(clone);
                calculate();
            }

            wrapper.addEventListener('input', calculate);
            wrapper.addEventListener('change', calculate);
            wrapper.addEventListener('click', e => {
                if (e.target.classList.contains('remove-row')) {
                    e.target.closest('.ingredient-row').remove();
                    calculate();
                }
            });

            document.getElementById('add-ingredient').addEventListener('click', addRow);

            addRow();
        });
    </script>

@endsection
