@extends('admin_dashboard')
@section('admin')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Update Purchases</a></li>

                            </ol>
                        </div>
                        <h4 class="page-title">Add Purchase</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">


                <div class="col-lg-8 col-xl-12">
                    <div class="card">
                        <div class="card-body">





                            <!-- end timeline content-->

                            <div class="tab-pane" id="settings">
                                <form id="myForm" method="post" action="{{ route('purchase.update') }}" >
                                    @csrf
                                    <input type="hidden" name="id" value="{{ $purchase->id }}">
                                    <h5 class="mb-4 text-uppercase"><i class="mdi mdi-account-circle me-1"></i> Add Purchase</h5>

                                    <div class="row">

                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label">Product Name</label>

                                                <select name="product_id" class="form-select" id="product_select">
                                                    <option disabled>Select Product</option>

                                                    @foreach($products as $cat)
                                                        <option value="{{ $cat->id }}"
                                                            {{ old('product_id', $purchase->product_id) == $cat->id ? 'selected' : '' }}>
                                                            {{ $cat->product_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label">Unit</label>
                                                <select name="unit_id" class="form-select" id="unit_select">
                                                    <option selected disabled>Select Unit</option>
                                                    @foreach($units as $cat)
                                                        <option value="{{ $cat->id }}"
                                                            {{ old('unit_id', $purchase->unit_id) == $cat->id ? 'selected' : '' }}>
                                                            {{ $cat->unit_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label">Supplier</label>
                                                <select name="supplier_id" class="form-select" id="example-select">
                                                    <option selected disabled>Select Supplier</option>
                                                    @foreach($supplier as $sup)
                                                        <option value="{{ $sup->id }}"
                                                            {{ old('supplier_id', $purchase->supplier_id) == $sup->id ? 'selected' : '' }}>
                                                            {{ $sup->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>





                                        <!--    <div class="col-md-6">
                                     <div class="form-group mb-3">
                                         <label for="firstname" class="form-label">Product Code    </label>
                                         <input type="text" name="product_code" class="form-control "   >

                                        </div>
                                     </div> -->
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="firstname" class="form-label">Buying Price   </label>
                                                <input type="number" name="buying_price" class="form-control "  >


                                            </div>

                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="firstname" class="form-label">Product Quantity   </label>
                                                <input type="number" name="product_qty" class="form-control">

                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="firstname" class="form-label">Purchase Date</label>
                                                <input type="date" name="purchase_date" class="form-control "   >

                                            </div>
                                        </div>


                                    </div> <!-- end row -->

                                    <div class="text-end">
                                        <button type="submit" class="btn btn-success waves-effect waves-light mt-2"><i class="mdi mdi-content-save"></i> Save</button>
                                    </div>
                                </form>
                            </div>
                            <!-- end settings content-->


                        </div>
                    </div> <!-- end card-->

                </div> <!-- end col -->
            </div>
            <!-- end row-->

        </div> <!-- container -->

    </div> <!-- content -->
    <script>
        document.getElementById('product_select').addEventListener('change', function () {

            let productId = this.value;
            let unitSelect = document.getElementById('unit_select');

            fetch(`/get-product-unit/${productId}`)
                .then(res => res.json())
                .then(data => {
                    if (data.unit_id) {
                        unitSelect.value = data.unit_id;
                        unitSelect.dispatchEvent(new Event('change'));
                    } else {
                        unitSelect.value = '';
                    }
                })
                .catch(err => console.error(err));
        });
    </script>


    <script type="text/javascript">
        $(document).ready(function (){
            $('#myForm').validate({
                rules: {
                    product_name: {
                        required : true,
                    },
                    unit_id: {
                        required : true,
                    },
                    supplier_id: {
                        required : true,
                    },



                    buying_price: {
                        required : true,
                    },
                    purchase_date: {
                        required : true,
                    },

                },
                messages :{
                    product_name: {
                        required : 'Please Enter Product Name',
                    },
                    unit_id: {
                        required : 'Please Select Unit',
                    },
                    supplier_id: {
                        required : 'Please Select Supplier',
                    },

                    purchase_date: {
                        required : 'Please Select Purchase Date',
                    },

                    buying_price: {
                        required : 'Please Enter Buying Price',
                    },


                },
                errorElement : 'span',
                errorPlacement: function (error,element) {
                    error.addClass('invalid-feedback');
                    element.closest('.form-group').append(error);
                },
                highlight : function(element, errorClass, validClass){
                    $(element).addClass('is-invalid');
                },
                unhighlight : function(element, errorClass, validClass){
                    $(element).removeClass('is-invalid');
                },
            });
        });

    </script>









@endsection
