@extends('admin_dashboard')
@section('admin')

 <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <!-- start page title -->
                        <div class="row">
                            <div class="col-12">
                                <div class="page-title-box">
                                    <div class="page-title-right">
                                        <ol class="breadcrumb m-0">

   <a href="{{ route('import.product') }}" class="btn btn-info rounded-pill waves-effect waves-light">Import </a>
   &nbsp;&nbsp;&nbsp;
   <a href="{{ route('export') }}" class="btn btn-danger rounded-pill waves-effect waves-light">Export </a>
   &nbsp;&nbsp;&nbsp;

      <a href="{{ route('add.product') }}" class="btn btn-primary rounded-pill waves-effect waves-light">Add Ingredient </a>
                                        </ol>
                                    </div>
                                    <h4 class="page-title">All Ingredient</h4>
                                </div>
                            </div>
                        </div>
                        <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Sl</th>
                                <th>Ingredient Name</th>
                                <th>Unit</th>
                                <th>Current Stock </th>
                                <th>Action</th>
                            </tr>
                        </thead>

                        <tbody>
                        @foreach($product as $key => $item)
                            @php
                                // Check if product's unit has a smaller unit
                                $childConversion = $item->unit->childConversions->first(); // get the smallest unit if exists
                                if($childConversion) {
                                    $baseUnitName = $childConversion->childUnit->unit_name; // smallest unit name
                                    $stockInBase = $item->stock * $childConversion->multiplier; // convert stock to base unit
                                } else {
                                    $baseUnitName = $item->unit->unit_name;
                                    $stockInBase = $item->stock;
                                }
                            @endphp

                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $item->product_name }}</td>
                                <td>{{ $item->unit->unit_name }}</td>
                                <td>{{ $item->stock }} {{ $baseUnitName }}</td>
                                <td>
                                    <a href="{{ route('edit.product',$item->id) }}" class="btn btn-blue rounded-pill waves-effect waves-light"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                    <a href="{{ route('delete.product',$item->id) }}" class="btn btn-danger rounded-pill waves-effect waves-light" id="delete"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->




                    </div> <!-- container -->

                </div> <!-- content -->


@endsection
