@extends('admin_dashboard')

@section('admin')
    <div class="content">

        <!-- HEADER -->
        <div class="card mb-4">
            <div class="card-body text-center">
                <h3 class="fw-bold text-danger">END OF DAY REGISTER SUMMARY</h3>
                <p class="mb-1">
                    Business Date: <strong>{{ $register->business_date }}</strong>
                </p>
                <p class="mb-0">
                    Cashier: <strong>{{ $register->user->name }}</strong>
                </p>
            </div>
        </div>

        <!-- FINANCIAL SUMMARY -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-success">
                    <div class="card-body text-center">
                        <h6>Total Sales</h6>
                        <h4 class="text-success">
                            {{ number_format($totalSales, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-primary">
                    <div class="card-body text-center">
                        <h6>Transactions</h6>
                        <h4>{{ $totalTransactions }}</h4>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-info">
                    <div class="card-body text-center">
                        <h6>Items Sold</h6>
                        <h4>{{ $totalItemsSold }}</h4>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card border-warning">
                    <div class="card-body text-center">
                        <h6>Cash Variance</h6>
                        <h4 class="{{ $variance == 0 ? 'text-success' : 'text-danger' }}">
                            {{ number_format($variance, 2) }}
                        </h4>
                    </div>
                </div>
            </div>
        </div>

        <!-- CASH RECONCILIATION -->
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="mb-3">Cash Reconciliation</h5>
                <table class="table table-bordered">
                    <tr>
                        <th>Expected Cash</th>
                        <td>{{ number_format($expectedCash, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Actual Cash Counted</th>
                        <td>{{ $actualCash !== null ? number_format($actualCash, 2) : '—' }}</td>
                    </tr>
                    <tr>
                        <th>Variance</th>
                        <td class="{{ $variance == 0 ? 'text-success' : 'text-danger' }}">
                            {{ number_format($variance, 2) }}
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- KITCHEN ACCOUNTABILITY -->
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="mb-3">Kitchen Production vs Sales</h5>

                <table class="table table-striped table-bordered">
                    <thead class="table-dark">
                    <tr>
                        <th>Recipe</th>
                        <th class="text-center">Approved Qty</th>
                        <th class="text-center">Sold Qty</th>
                        <th class="text-center">Remaining Qty</th>
                    </tr>
                    </thead>
                    <tbody>

                    @if(empty($items))
                        <tr>
                            <td colspan="4" class="text-center text-muted">
                                No approved kitchen production available
                            </td>
                        </tr>
                    @else
                        @foreach($items as $item)
                            <tr>
                                <td>{{ $item->recipe_name }}</td>

                                <td class="text-center fw-bold">
                                    {{ $item->approved_qty }}
                                </td>

                                <td class="text-center">
                                    {{ $item->sold_qty }}
                                </td>

                                <td class="text-center">
                                    @if($item->remaining_qty > 0)
                                        <span class="badge bg-success text-dark">
                        {{ $item->remaining_qty }} Remaining
                    </span>
                                    @elseif($item->remaining_qty == 0)
                                        <span class="badge bg-success">
                        Fully Sold
                    </span>
                                    @else
                                        <span class="badge bg-danger">
                        Oversold
                    </span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif

                    </tbody>

                </table>
            </div>
        </div>

        <!-- FOOTER -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p>
                            Register Status:
                            <strong>{{ ucfirst($register->status) }}</strong>
                        </p>
                        <p>
                            Closed At:
                            <strong>{{ $register->closed_at ?? '—' }}</strong>
                        </p>
                    </div>

                    <div class="col-md-6 text-end">
                        <button onclick="window.print()" class="btn btn-primary">
                            🖨 Print Report
                        </button>

                        @if($register->status === 'open')
                            <form action="{{ route('register.close', $register->id) }}"
                                  method="POST"
                                  class="d-inline">
                                @csrf
                                <button class="btn btn-danger">
                                    Close Register
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
