@extends('admin_dashboard')

@section('admin')
    <div class="content">
        <div class="card col-md-4 mx-auto">
            <div class="card-body">
                <h5>Open Register</h5>

                @php
                    // ✅ Fetch any open register for the current user (ignore date)
                    $currentRegister = \App\Models\Register::where('user_id', auth()->id())
                        ->where('status', 'open')
                        ->first();
                @endphp

                @if(session('error'))
                    <div class="alert alert-danger">{{ session('error') }}</div>
                @endif

                @if($currentRegister)
                    <div class="alert alert-info">
                        You already have an open register.
                        <a href="{{ route('pos.index') }}" class="btn btn-primary btn-sm">
                            Go to POS
                        </a>
                    </div>
                @else
                    <form method="POST" action="{{ route('register.store') }}">
                        @csrf
                        <div class="mb-3">
                            <label>Opening Cash</label>
                            <input type="number" step="0.01" name="opening_cash"
                                   class="form-control" required>
                        </div>

                        <button class="btn btn-success w-100">
                            Open Register
                        </button>
                    </form>
                @endif

            </div>
        </div>
    </div>
@endsection
