@extends('admin_dashboard')

@section('admin')
    <div class="content">

        <h3 class="mb-4 fw-bold text-danger">REGISTER CLOSURE HISTORY</h3>

        @foreach($closures as $closure)
            <div class="card mb-4 border-0 shadow-sm bg-dark text-light">

                <!-- HEADER -->
                <div class="card-header bg-black text-warning fw-bold">
                    Register #{{ $closure->register_id }} |
                    Cashier: {{ $closure->user->name }} |
                    Closed: {{ $closure->closed_at }}
                </div>

                <!-- SUMMARY -->
                <div class="card-body">

                    <div class="row text-center mb-4">
                        <div class="col-md-3">
                            <small>Total Sales</small>
                            <h5 class="text-success">{{ number_format($closure->total_sales, 2) }}</h5>
                        </div>
                        <div class="col-md-3">
                            <small>Transactions</small>
                            <h5>{{ $closure->total_transactions }}</h5>
                        </div>
                        <div class="col-md-3">
                            <small>Items Sold</small>
                            <h5>{{ $closure->total_items_sold }}</h5>
                        </div>
                        <div class="col-md-3">
                            <small>Variance</small>
                            <h5 class="{{ $closure->variance == 0 ? 'text-success' : 'text-danger' }}">
                                {{ number_format($closure->variance, 2) }}
                            </h5>
                        </div>
                    </div>

                    <!-- KITCHEN VS SALES -->
                    <div class="table-responsive">
                        <table class="table table-dark table-hover table-bordered align-middle">
                            <thead class="table-secondary text-dark">
                            <tr>
                                <th>Recipe</th>
                                <th class="text-center">Approved</th>
                                <th class="text-center">Sold</th>
                                <th class="text-center">Remaining</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($closure->items as $item)
                                <tr>
                                    <td>{{ $item->recipe_name }}</td>
                                    <td class="text-center fw-bold">{{ $item->approved_qty }}</td>
                                    <td class="text-center">{{ $item->sold_qty }}</td>
                                    <td class="text-center">
                                        @if($item->remaining_qty > 0)
                                            <span class="badge bg-warning text-dark">
                                                {{ $item->remaining_qty }}
                                            </span>
                                        @elseif($item->remaining_qty == 0)
                                            <span class="badge bg-success">
                                                Balanced
                                            </span>
                                        @else
                                            <span class="badge bg-danger">
                                                Oversold
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        @endforeach

    </div>
@endsection
