@extends('admin_dashboard')
@section('admin')

    <div class="container-fluid">

        <h4 class="mb-4">Yearly Payroll Report</h4>

        {{-- Year Selector --}}
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="{{ route('payroll.report.yearly') }}">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label>Select Year</label>
                            <select name="year" class="form-control" required>
                                <option value="">-- Choose Year --</option>
                                @for($y = now()->year; $y >= 2020; $y--)
                                    <option value="{{ $y }}" {{ ($year ?? '') == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>

                        <div class="col-md-2">
                            <button class="btn btn-primary w-100">
                                Generate Report
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        {{-- Report Table --}}
        @if($payrolls->count())
            <div class="card">
                <div class="card-body table-responsive">

                    <table class="table table-bordered table-striped">
                        <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>Employee</th>
                            <th>Basic</th>
                            <th>Allowances</th>
                            <th>Gross Pay</th>
                            <th>Loan Deductions</th>
                            <th>Other Deductions</th>
                            <th>Total Deductions</th>
                            <th>Net Pay</th>
                        </tr>
                        </thead>

                        <tbody>
                        @foreach($payrolls as $key => $pay)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $pay->employee->full_name ?? 'N/A' }}</td>
                                <td>{{ number_format($pay->basic_salary, 2) }}</td>
                                <td>{{ number_format($pay->total_allowances, 2) }}</td>
                                <td>{{ number_format($pay->gross_pay, 2) }}</td>
                                <td>{{ number_format($payroll->loan_deductions, 2) }}</td>
                                <td>{{ number_format($payroll->other_deductions, 2) }}</td>
                                <td>{{ number_format($payroll->total_deductions, 2) }}</td>
                                <td>{{ number_format($payroll->net_pay, 2) }}</td>
                            </tr>
                        @endforeach
                        </tbody>

                        <tfoot class="table-secondary fw-bold">
                        <tr>
                            <th colspan="4">TOTAL</th>
                            <th>{{ number_format($summary['gross'],2) }}</th>
                            <th></th>
                            <th></th>
                            <th>{{ number_format($summary['deductions'],2) }}</th>
                            <th>{{ number_format($summary['net'],2) }}</th>
                        </tr>
                        </tfoot>
                    </table>

                </div>
            </div>
        @elseif(isset($year))
            <p class="text-center text-muted">
                No payroll data found for {{ $year }}.
            </p>
        @endif

    </div>

@endsection
