@extends('admin_dashboard')
@section('admin')
is it here
    @php
        $months = [
            1=>'January',2=>'February',3=>'March',4=>'April',
            5=>'May',6=>'June',7=>'July',8=>'August',
            9=>'September',10=>'October',11=>'November',12=>'December'
        ];
    @endphp

    <div class="container-fluid">

        {{-- Page Header --}}
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4>Monthly Payroll Report — {{ $months[(int)$month] }} {{ $year }}</h4>
            @if($payrolls->count())
                <a href="{{ route('payroll.report.monthly.export', $year.'-'.$month) }}" class="btn btn-success">
                    <i class="fas fa-file-excel"></i> Export to Excel
                </a>
            @endif
        </div>

        {{-- Payroll Table --}}
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered table-striped table-hover align-middle">
                    <thead class="table-dark text-center">
                    <tr>
                        <th>#</th>
                        <th>Employee</th>
                        <th>Basic Salary</th>
                        <th>Allowances</th>
                        <th>Gross Pay</th>
                        <th>Other Deductions</th>
                        <th>Loan Deductions</th>
                        <th>Net Pay</th>
                    </tr>
                    </thead>

                    <tbody>
                    @forelse($payrolls as $key => $pay)
                        <tr>
                            <td class="text-center">{{ $key + 1 }}</td>
                            <td>{{ $pay->employee->full_name ?? 'N/A' }}</td>
                            <td class="text-end">{{ number_format($pay->basic_salary, 2) }}</td>
                            <td class="text-end">{{ number_format($pay->total_allowances, 2) }}</td>
                            <td class="text-end">{{ number_format($pay->gross_pay, 2) }}</td>
                            <td class="text-end">{{ number_format($pay->total_deductions, 2) }}</td>
                            <td class="text-end">{{ number_format($pay->loan_deductions, 2) }}</td>
                            <td class="text-end text-success fw-bold">{{ number_format($pay->net_pay, 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No payroll data available for this month.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>

                    @if($payrolls->count())
                        <tfoot class="table-secondary text-center">
                        <tr>
                            <th colspan="2">TOTAL</th>
                            <th class="text-end">{{ number_format($summary['basic'] ?? 0, 2) }}</th>
                            <th class="text-end">{{ number_format($summary['allowances'] ?? 0, 2) }}</th>
                            <th class="text-end">{{ number_format($summary['gross'] ?? 0, 2) }}</th>
                            <th class="text-end">{{ number_format($summary['deductions'] ?? 0, 2) }}</th>
                            <th class="text-end">{{ number_format($summary['loan'] ?? 0, 2) }}</th>
                            <th class="text-end">{{ number_format($summary['net'] ?? 0, 2) }}</th>
                        </tr>
                        </tfoot>
                    @endif
                </table>
            </div>
        </div>

    </div>

@endsection
