@extends('admin_dashboard')
@section('admin')

    <h4>Payroll Runs</h4>

    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
        <thead>
        <tr>
            <th>#</th>
            <th>Pay Period</th>
            <th>Status</th>
            <th>Total Employees</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>

        @forelse($runs as $run)
            <tr>
                <td>{{ $run->id }}</td>
                <td>{{ $run->pay_period }}</td>
                <td>
                <span class="badge
                    {{ $run->status === 'approved' ? 'bg-success' : 'bg-warning' }}">
                    {{ strtoupper($run->status) }}
                </span>
                </td>
                <td>{{ $run->employees->count() }}</td>
                <td class="d-flex gap-1">

                    {{-- View always --}}
                    <a href="{{ route('backend.payroll.payroll_review', $run->id) }}"
                       class="btn btn-sm btn-primary">
                        View
                    </a>

                    {{-- If NOT approved → show Approve --}}
                    @if($run->status !== 'approved')
                        <form method="POST"
                              action="{{ route('backend.payroll.approve', $run->id) }}">
                            @csrf
                            <button class="btn btn-sm btn-success"
                                    onclick="return confirm('Approve this payroll?')">
                                Approve
                            </button>
                        </form>
                    @endif

                    {{-- If approved → show Print PDF --}}
                    @if($run->status === 'approved')
                        <a href="{{ route('backend.payroll.print', $run->id) }}"
                           class="btn btn-sm btn-danger">
                            Print PDF
                        </a>
                    @endif

                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="text-center">No payroll runs found</td>
            </tr>
        @endforelse

        </tbody>
    </table>

@endsection
