@extends('admin_dashboard')
@section('admin')

    <h4>Payroll Review – {{ $run->pay_period }}</h4>
    <p>Status: <strong>{{ strtoupper($run->status) }}</strong></p>

    <table class="table table-bordered table-sm">
        <thead class="table-light">
        <tr>
            <th>#</th>
            <th>Employee</th>
            <th>Basic Salary</th>
            <th>Allowances</th>
            <th>Deductions</th>
            <th>Loan Deductions</th>
            <th>Net Pay</th>
            <th>Status</th>
        </tr>
        </thead>

        <tbody>
        @php
            $totalBasic = 0;
            $totalAllowances = 0;
            $totalDeductions = 0;
            $totalLoans = 0;
            $totalNet = 0;
        @endphp

        @foreach($run->employees as $item)
            @php
                $employee = $item->employee;

                $basic = $employee->basic_salary ?? 0;

                // Allowances
                $allowances = $employee->allowances->sum(function ($a) use ($basic) {
                    return $a->type === 'fixed'
                        ? $a->amount
                        : ($basic * $a->amount / 100);
                });

                // Deductions
                $deductions = $employee->deductions->sum(function ($d) use ($basic) {
                    return $d->type === 'fixed'
                        ? $d->amount
                        : ($basic * $d->amount / 100);
                });

                // Loan deductions (preview only)
                $loanDeductions = $employee->loans->sum(function ($loan) {
                    return $loan->remaining_amount > 0
                        ? min(2000, $loan->remaining_amount)
                        : 0;
                });

                $netPay = $basic + $allowances - ($deductions + $loanDeductions);

                // Totals
                $totalBasic += $basic;
                $totalAllowances += $allowances;
                $totalDeductions += $deductions;
                $totalLoans += $loanDeductions;
                $totalNet += $netPay;
            @endphp

            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $employee->full_name }}</td>
                <td>{{ number_format($basic, 2) }}</td>
                <td>{{ number_format($allowances, 2) }}</td>
                <td>{{ number_format($deductions, 2) }}</td>
                <td>{{ number_format($loanDeductions, 2) }}</td>
                <td><strong>{{ number_format($netPay, 2) }}</strong></td>
                <td>
                <span class="badge {{ $item->status === 'approved' ? 'bg-success' : 'bg-secondary' }}">
                    {{ strtoupper($item->status) }}
                </span>
                </td>
            </tr>
        @endforeach
        </tbody>

        <tfoot class="table-dark">
        <tr>
            <th colspan="2">TOTALS</th>
            <th>{{ number_format($totalBasic, 2) }}</th>
            <th>{{ number_format($totalAllowances, 2) }}</th>
            <th>{{ number_format($totalDeductions, 2) }}</th>
            <th>{{ number_format($totalLoans, 2) }}</th>
            <th>{{ number_format($totalNet, 2) }}</th>
            <th></th>
        </tr>
        </tfoot>
    </table>
    @if($run->status === 'draft')
        <form method="POST" action="{{ route('backend.payroll.approve', $run->id) }}">
            @csrf
            <button class="btn btn-success mt-3">
                Approve Payroll
            </button>
        </form>
    @endif


@endsection
