<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payroll {{ $run->pay_period }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 6px; text-align: right; }
        th { background: #f2f2f2; }
        td.name, th.name { text-align: left; }
    </style>
</head>
<body>

<h3 style="text-align:center">Payroll Report</h3>
<p><strong>Pay Period:</strong> {{ $run->pay_period }}</p>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th class="name">Employee</th>
        <th>Basic</th>
        <th>Allowances</th>
        <th>Deductions</th>
        <th>Loans</th>
        <th>Gross</th>
        <th>Net</th>
    </tr>
    </thead>
    <tbody>

    @php
        $totalBasic = $totalAllow = $totalDed = $totalLoan = $totalGross = $totalNet = 0;
    @endphp

    @foreach($payrolls as $payroll)
        @php
            $totalBasic += $payroll->basic_salary;
            $totalAllow += $payroll->total_allowances;
            $totalDed   += $payroll->total_deductions;
            $totalLoan  += $payroll->loan_deductions;
            $totalGross += $payroll->gross_pay;
            $totalNet   += $payroll->net_pay;
        @endphp
        <tr>
            <td>{{ $loop->iteration }}</td>
            <td class="name">{{ $payroll->employee->full_name }}</td>
            <td>{{ number_format($payroll->basic_salary, 2) }}</td>
            <td>{{ number_format($payroll->total_allowances, 2) }}</td>
            <td>{{ number_format($payroll->total_deductions, 2) }}</td>
            <td>{{ number_format($payroll->loan_deductions, 2) }}</td>
            <td>{{ number_format($payroll->gross_pay, 2) }}</td>
            <td>{{ number_format($payroll->net_pay, 2) }}</td>
        </tr>
    @endforeach

    <tr>
        <th colspan="2">TOTAL</th>
        <th>{{ number_format($totalBasic, 2) }}</th>
        <th>{{ number_format($totalAllow, 2) }}</th>
        <th>{{ number_format($totalDed, 2) }}</th>
        <th>{{ number_format($totalLoan, 2) }}</th>
        <th>{{ number_format($totalGross, 2) }}</th>
        <th>{{ number_format($totalNet, 2) }}</th>
    </tr>

    </tbody>
</table>

</body>
</html>
