@extends('admin_dashboard')
@section('admin')

    <div class="content">
        <h4>Order Preview: {{ $order->order_no }}</h4>
        <p>
            <strong>Date:</strong> {{ $order->order_date }} <br>
            <strong>Time:</strong> {{ $order->created_at->format('H:i:s') }} <br>
            <strong>Submitted By:</strong> {{ $order->chef?->name ?? 'N/A' }}
        </p>

        @php
            $recipesGrouped = [];
            foreach ($order->ingredients as $ing) {
                $recipeName = $ing->recipe_name ?? 'Unknown Recipe';
                $recipesGrouped[$recipeName][] = $ing;
            }
        @endphp

        @foreach($recipesGrouped as $recipeName => $ingredients)
            <h5 class="mt-3">{{ $recipeName }} (Qty: {{ $ingredients[0]->recipe_qty ?? '-' }})</h5>
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>Ingredient</th>
                    <th>Required Qty</th>
                </tr>
                </thead>
                <tbody>
                @foreach($ingredients as $ing)
                    <tr>
                        <td>{{ $ing->product->product_name }}</td>
                        <td>{{ $ing->required_qty }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        @endforeach

        <h5 class="text-end mt-3">Grand Total: {{ number_format($order->total_cost,2) }}</h5>

        <div class="mt-3 text-end">

            {{-- Approve button (only when draft) --}}
            @if($order->status === 'draft')
                <form action="{{ route('chef.kitchen.approve', $order->id) }}" method="POST" class="d-inline">
                    @csrf
                    <button class="btn btn-success">
                        Approve Order
                    </button>
                </form>
            @endif

            {{-- PDF button (only when approved) --}}
            @if($order->status === 'approved')
                <a href="{{ route('chef.kitchen.pdf', $order->id) }}"
                   class="btn btn-primary"
                   target="_blank">
                    Print PDF
                </a>
            @endif

        </div>

    </div>

@endsection
