<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Kitchen Order {{ $order->order_no }}</title>

    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px;
        }

        th {
            background: #f2f2f2;
        }

        .text-center {
            text-align: center;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>

{{-- ================= HEADER ================= --}}
<h2>Kitchen Order Sheet</h2>

<p>
    <strong>Order No:</strong> {{ $order->order_no }} <br>
    <strong>Chef:</strong> {{ $order->chef->name ?? 'N/A' }} <br>
    <strong>Status:</strong> {{ ucfirst($order->status) }} <br>
    <strong>Date:</strong> {{ $order->created_at->format('d M Y H:i') }}
</p>

{{-- ================= PAGE 1 : RECIPES & INGREDIENTS ================= --}}
<h3>Recipes & Ingredients</h3>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th>Recipe</th>
        <th>Ingredient</th>
        <th>Required Qty</th>
        <th>Unit</th>
        <th>Qty to Make</th>
    </tr>
    </thead>
    <tbody>

    @php
        $groupedRecipes = $order->ingredients->groupBy('recipe_name');
        $rowNo = 1;
    @endphp

    @foreach($groupedRecipes as $recipeName => $items)
        @php
            $rowspan = $items->count();
            $recipeQty = $items->first()->recipe_qty;
        @endphp

        @foreach($items as $index => $item)
            <tr>
                {{-- Number --}}
                <td class="text-center">{{ $rowNo }}</td>

                {{-- Recipe name (once) --}}
                @if($index === 0)
                    <td rowspan="{{ $rowspan }}" class="text-center">
                        <strong>{{ $recipeName }}</strong>
                    </td>
                @endif

                {{-- Ingredient --}}
                <td>{{ $item->product->product_name ?? 'N/A' }}</td>

                {{-- Required Qty --}}
                <td class="text-center">
                    {{ number_format($item->required_qty, 3) }}
                </td>

                {{-- Unit --}}
                <td class="text-center">
                    {{ $item->product->unit->unit_symbol ?? '' }}
                </td>

                {{-- Qty to Make (once) --}}
                @if($index === 0)
                    <td rowspan="{{ $rowspan }}" class="text-center">
                        <strong>{{ $recipeQty }}</strong>
                    </td>
                @endif
            </tr>
        @endforeach

        {{-- draw a separating line AFTER each recipe --}}
        <tr>
            <td colspan="6" style="background:#f9f9f9;height:4px;padding:0;"></td>
        </tr>

        @php $rowNo++; @endphp
    @endforeach

    </tbody>
</table>


@if($order->remarks)
    <p><strong>Remarks:</strong> {{ $order->remarks }}</p>
@endif

{{-- ================= PAGE BREAK ================= --}}
<div class="page-break"></div>

{{-- ================= PAGE 2 : INGREDIENT SUMMARY ================= --}}
<h3>Ingredient Summary </h3>
<p>
    <strong>Order No:</strong> {{ $order->order_no }} <br>
    <strong>Chef:</strong> {{ $order->chef->name ?? 'N/A' }} <br>
    <strong>Status:</strong> {{ ucfirst($order->status) }} <br>
    <strong>Date:</strong> {{ $order->created_at->format('d M Y H:i') }}
</p>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th>Ingredient</th>
        <th>Total Qty Required</th>
        <th>Unit</th>
    </tr>
    </thead>
    <tbody>
    @foreach($groupedIngredients as $index => $ingredient)
        <tr>
            <td class="text-center">{{ $index + 1 }}</td>
            <td>{{ $ingredient['ingredient'] }}</td>
            <td class="text-center">
                {{ number_format($ingredient['total_qty'], 3) }}
            </td>
            <td class="text-center">{{ $ingredient['unit'] }}</td>
        </tr>
    @endforeach
    </tbody>
</table>

<br><br>

<p>
    <strong>Prepared By:</strong> ________________________ <br><br>
    <strong>Approved By:</strong> ________________________ <br><br>
    <strong>Date:</strong> ________________________
</p>

</body>
</html>
