@extends('admin_dashboard')
@section('admin')

    <div class="content">
        <h5>Your  Orders</h5>

        <table id="basic-datatable" class="table dt-responsive nowrap w-100">
            <thead>
            <tr>
                <th>Order No</th>
                <th>Date</th>
                <th>Total Cost</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{ $order->order_no }}</td>
                    <td>{{ $order->order_date }}</td>
                    <td>{{ number_format($order->total_cost, 2) }}</td>
                    <td>
                        {{-- Dynamic Badge for Status --}}
                        <span class="badge {{ $order->status === 'approved' ? 'bg-success' : 'bg-warning' }}">
                    {{ ucfirst($order->status) }}
                </span>
                    </td>
                    <td>
                        {{-- Preview is always allowed --}}
                        <a href="{{ route('chef.kitchen.preview', $order->id) }}"
                           class="btn btn-sm btn-info">
                            Preview
                        </a>

                        {{-- Approve only when draft --}}
                        @if($order->status === 'draft')
                            <form action="{{ route('chef.kitchen.approve', $order->id) }}"
                                  method="POST"
                                  class="d-inline"
                                  onsubmit="return confirm('Are you sure you want to approve this order?')">
                                @csrf
                                <button class="btn btn-sm btn-success">
                                    Approve
                                </button>
                            </form>
                        @endif

                        {{-- PDF only when approved --}}
                        @if($order->status === 'approved')
                            <a href="{{ route('chef.kitchen.pdf', $order->id) }}"
                               class="btn btn-sm btn-primary"
                               target="_blank">
                                PDF
                            </a>
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>

        </table>
    </div>

@endsection
