@extends('admin_dashboard')
@section('admin')

    <div class="container">
        <h4>Assign Allowances & Deductions</h4>
        <p><strong>{{ $employee->full_name }}</strong></p>

        <form method="POST" action="{{ route('employee.benefits.update', $employee->id) }}">
            @csrf

            <div class="row">
                {{-- Allowances --}}
                <div class="col-md-6">
                    <h5>Allowances</h5>

                    @foreach($allowances as $allowance)
                        <div class="form-check">
                            <input
                                type="checkbox"
                                name="allowances[]"
                                value="{{ $allowance->id }}"
                                class="form-check-input"
                                {{ $employee->allowances->contains($allowance->id) ? 'checked' : '' }}
                            >
                            <label class="form-check-label">
                                {{ $allowance->name }}
                                ({{ $allowance->type }} - {{ number_format($allowance->amount,2) }})
                            </label>
                        </div>
                    @endforeach
                </div>

                {{-- Deductions --}}
                <div class="col-md-6">
                    <h5>Deductions</h5>

                    @foreach($deductions as $deduction)
                        <div class="form-check">
                            <input
                                type="checkbox"
                                name="deductions[]"
                                value="{{ $deduction->id }}"
                                class="form-check-input"
                                {{ $employee->deductions->contains($deduction->id) ? 'checked' : '' }}
                            >
                            <label class="form-check-label">
                                {{ $deduction->name }}
                                ({{ $deduction->type }} - {{ number_format($deduction->amount,2) }})
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <button class="btn btn-primary mt-3">
                Save Assignments
            </button>
        </form>
    </div>

@endsection
