@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">
        <h4>Add Loan / Advance for {{ $employee->full_name }}</h4>

        <form action="{{ route('employee.loans.store') }}" method="POST">
            @csrf
            <input type="hidden" name="employee_id" value="{{ $employee->id }}">

            <div class="mb-3">
                <label>Type</label>
                <select name="type" class="form-control" required>
                    <option value="loan">Loan</option>
                    <option value="advance">Advance</option>
                </select>
            </div>

            <div class="mb-3">
                <label>Amount</label>
                <input type="number" name="amount" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Description</label>
                <textarea name="description" class="form-control" rows="2"></textarea>
            </div>

            <button class="btn btn-primary">Save</button>
            <a href="{{ route('employee.loans.index') }}" class="btn btn-secondary">Back</a>
        </form>
    </div>
@endsection
