@extends('admin_dashboard')
@section('admin')
    <div class="container-fluid">

        <div class="row mb-3">
            <div class="col-md-6">
                <h4>Departments</h4>
            </div>
            <div class="col-md-6 text-end">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addDepartment">
                    + Add Department
                </button>
            </div>
        </div>

        {{-- Alerts --}}
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="card">
            <div class="card-body">
                <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Code</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th width="150">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($departments as $key => $department)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $department->name }}</td>
                            <td>{{ $department->code }}</td>
                            <td>{{ $department->description }}</td>
                            <td>
                                @if($department->status)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-danger">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <button
                                    class="btn btn-sm btn-info"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editDepartment{{ $department->id }}">
                                    Edit
                                </button>

                                <a href="{{ route('departments.delete', $department->id) }}"
                                   onclick="return confirm('Delete this department?')"
                                   class="btn btn-sm btn-danger">
                                    Delete
                                </a>
                            </td>
                        </tr>

                        {{-- Edit Modal --}}
                        <div class="modal fade" id="editDepartment{{ $department->id }}">
                            <div class="modal-dialog">
                                <form method="POST" action="{{ route('departments.update', $department->id) }}">
                                    @csrf
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5>Edit Department</h5>
                                            <button class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-2">
                                                <label>Name</label>
                                                <input type="text" name="name" value="{{ $department->name }}" class="form-control" required>
                                            </div>
                                            <div class="mb-2">
                                                <label>Code</label>
                                                <input type="text" name="code" value="{{ $department->code }}" class="form-control" required>
                                            </div>
                                            <div class="mb-2">
                                                <label>Description</label>
                                                <textarea name="description" class="form-control">{{ $department->description }}</textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button class="btn btn-primary">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    {{-- Add Modal --}}
    <div class="modal fade" id="addDepartment">
        <div class="modal-dialog">
            <form method="POST" action="{{ route('departments.store') }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5>Add Department</h5>
                        <button class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-2">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="mb-2">
                            <label>Code</label>
                            <input type="text" name="code" class="form-control" required>
                        </div>
                        <div class="mb-2">
                            <label>Description</label>
                            <textarea name="description" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection
