<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->constrained('sales')->cascadeOnDelete();
            $table->foreignId('kitchen_order_id')->nullable()->constrained('kitchen_orders')->nullOnDelete();
            $table->foreignId('kitchen_order_ingredient_id')->nullable()->constrained('kitchen_order_ingredients')->nullOnDelete();
            $table->foreignId('recipe_id')->constrained('recipes');
            $table->string('recipe_name');
            $table->decimal('unit_price', 15, 2);
            $table->decimal('qty', 15, 2);
            $table->decimal('total_price', 15, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_items');
    }
};
