<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('recipes', function (Blueprint $table) {
            $table->id();
            $table->string('recipe_name')->unique();
            $table->decimal('yield_qty', 10, 2);       // e.g 100 chapati
            $table->foreignId('yield_unit_id')->constrained('units');
            $table->decimal('selling_price', 10, 2);   // price per unit
            $table->decimal('production_cost', 10, 2); // TOTAL cost
            $table->decimal('unit_cost', 10, 4);       // cost per unit
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('recipes');
    }
};
