<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Product;
use App\Models\Purchases;
use App\Models\Supplier;
use App\Models\Unit;
use Carbon\Carbon;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class ProductController extends Controller
{
    //
    public function AllProduct(){

        $product = Product::latest()->get();
        return view('backend.product.all_product',compact('product'));

    } // End Method
    public function AddProduct(){

        $units = Unit::latest()->get();
        $supplier = Supplier::latest()->get();
        return view('backend.product.add_product',compact('units','supplier'));
    }// End Method

    public function StoreProduct(Request $request)
    {
        $request->validate([
            'product_name' => 'required|max:200|unique:products,product_name',
            'unit_id' => 'required|exists:units,id',
        ]);

        Product::create([
            'product_name' => $request->product_name,
            'stock' => 0,
            'unit_id' => $request->unit_id,
        ]);

        return redirect()
            ->route('all.product')
            ->with([
                'message' => 'Product Added Successfully',
                'alert-type' => 'success'
            ]);
    }

    public function EditProduct($id){
        $product = Product::findOrFail($id);
        $units = Unit::latest()->get();
        $suppliers = Supplier::latest()->get();
        return view('backend.product.edit_product',compact('product','units','suppliers'));

    } // End Method
    public function UpdateProduct(Request $request)
    {
        $product_id = $request->id;

        // Find current stock based on purchase
        $lastPurchase = Purchases::where('product_id', $product_id)
            ->orderByDesc('id')
            ->first();

        $currentStock = $lastPurchase ? $lastPurchase->purchase_qty : 0;

        Product::findOrFail($product_id)->update([
            'product_name' => $request->product_name,
            'unit_id'      => $request->unit_id,
            'stock'        => $currentStock,
            'updated_at'   => Carbon::now(),
        ]);

        $notification = [
            'message' => 'Product Updated Successfully',
            'alert-type' => 'success',
        ];

        return redirect()->route('all.product')->with($notification);
    }


    public function getProductUnit(Product $product)
    {
        return response()->json([
            'unit_id' => $product->unit->id,
            'unit_name' => $product->unit->unit_name,
        ]);
    }






}
