<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Allowance;
use App\Models\Deduction;
use Illuminate\Http\Request;

class DeductionController extends Controller
{
    //
    public function index()
    {
        $deductions = Deduction::all();
        return view('backend.deductions.deductions_index', compact('deductions'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required',
            'type'=>'required|in:fixed,percentage',
            'amount'=>'required|numeric'
        ]);

        Deduction::create($request->all());
        $notification = [
            'message' => ' Added Successfully',
            'alert-type' => 'success',
        ];
        return back()->with($notification);
    }

    public function edit($id)
    {
        $deduction = Deduction::findOrFail($id);
        $deductions = Deduction::all(); // for table
        return view('backend.deductions.deductions_edit', compact('deduction','deductions'));
    }

    public function update(Request $request, $id)
    {
        $deductions = Deduction::findOrFail($id);

        $request->validate([
            'name'=>'required',
            'type'=>'required|in:fixed,percentage',
            'amount'=>'required|numeric'
        ]);

        $deductions->update($request->all());
        $notification = [
            'message' => ' Added Successfully',
            'alert-type' => 'success',
        ];
        return redirect()->route('deductions.index')->with($notification);
    }

    public function destroy($id)
    {
        Deduction::findOrFail($id)->delete();
        $notification = [
            'message' => ' Deleted Successfully',
            'alert-type' => 'success',
        ];
        return back()->with($notification);
    }
}
