<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Allowance;
use Illuminate\Http\Request;

class AllowanceController extends Controller
{
    //
    public function index()
    {
        $allowances = Allowance::all();
        return view('backend.allowances.allowances_index', compact('allowances'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required',
            'type'=>'required|in:fixed,percentage',
            'amount'=>'required|numeric'
        ]);

        Allowance::create($request->all());
        $notification = [
            'message' => ' Added Successfully',
            'alert-type' => 'success',
        ];
        return back()->with($notification);
    }

    public function edit($id)
    {
        $allowance = Allowance::findOrFail($id); // single
        $allowances = Allowance::all(); // for table
        return view('backend.allowances.allowances_edit', compact('allowance','allowances'));
    }

    public function update(Request $request, $id)
    {
        $allowance = Allowance::findOrFail($id);

        $request->validate([
            'name'=>'required',
            'type'=>'required|in:fixed,percentage',
            'amount'=>'required|numeric'
        ]);

        $allowance->update($request->all());
        $notification = [
            'message' => ' Updated Successfully',
            'alert-type' => 'success',
        ];
        return redirect()->route('allowances.index')->with($notification);
    }

    public function destroy($id)
    {
        Allowance::findOrFail($id)->delete();
        $notification = [
            'message' => ' Deleted Successfully',
            'alert-type' => 'success',
        ];
        return back()->with($notification);
    }
}
